/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.PasswordInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.ScrolledContainer;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 420;
    public static final int MAX_RETRIES = 3;
    private int retries = 0;
    private boolean showPassword = false;
    private TextInput userInput = null;
    private PasswordInput passwordInput = null;
    private String text = null;
    private String userText = null;
    private String labelText = this.i18n.tr("Passwort");
    private String errorText = null;
    private String enteredUsername = null;
    private String enteredPassword = null;
    private LabelInput error = null;
    private boolean smallDisplay = false;

    public PasswordDialog(int position) {
        super(position);
        this.setSize(420, -1);
        this.setTitle(this.i18n.tr("Passwort"));
        this.setSideImage(SWTUtil.getImage("dialog-password.png"));
        this.smallDisplay = Customizing.SETTINGS.getBoolean("application.scrollview", false);
    }

    @Override
    protected void onEscape() {
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.text = text;
    }

    public void setUsernameText(String text) {
        this.userText = text;
    }

    public void setLabelText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.labelText = text;
    }

    protected final void setErrorText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.errorText = text;
        if (this.error != null) {
            this.error.setValue(this.errorText);
        }
    }

    public void setShowPassword(boolean show) {
        this.showPassword = show;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        if (this.text != null && this.text.length() > 0) {
            SimpleContainer tc = null;
            if (this.smallDisplay && this.text.length() > 500) {
                ScrolledContainer sc = new ScrolledContainer(parent);
                tc = new SimpleContainer(sc.getComposite());
                this.text = this.text + "\n";
            } else {
                tc = new SimpleContainer(parent);
            }
            tc.addText(this.text, true);
        }
        SimpleContainer container = new SimpleContainer(parent);
        TextInput textInput = this.userInput = this.userText != null && this.userText.length() > 0 ? new TextInput(null) : null;
        if (this.userInput != null) {
            this.userInput.setValue(this.enteredUsername != null ? this.enteredUsername : Application.getStartupParams().getUsername());
            this.userInput.setName(this.userText);
            this.userInput.setMandatory(true);
            this.userInput.focus();
            container.addInput(this.userInput);
        }
        this.passwordInput = new PasswordInput(this.enteredPassword);
        this.passwordInput.setName(this.labelText);
        this.passwordInput.setShowPassword(this.showPassword);
        if (this.userInput == null) {
            this.passwordInput.focus();
        }
        container.addInput(this.passwordInput);
        this.error = new LabelInput(this.errorText);
        this.error.setName("");
        this.error.setColor(Color.ERROR);
        this.error.setValue(this.errorText);
        container.addInput(this.error);
        this.extend(container);
        ((Text)this.passwordInput.getControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.passwordModified((String)PasswordDialog.this.passwordInput.getValue());
            }
        });
        ButtonArea buttons = new ButtonArea();
        buttons.addButton("    " + this.i18n.tr("OK") + "    ", new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                String p;
                ++PasswordDialog.this.retries;
                if (PasswordDialog.this.userInput != null) {
                    String u = (String)PasswordDialog.this.userInput.getValue();
                    if (!PasswordDialog.this.checkUsername(u)) {
                        return;
                    }
                    PasswordDialog.this.enteredUsername = u;
                }
                if (!PasswordDialog.this.checkPassword(p = (String)PasswordDialog.this.passwordInput.getValue())) {
                    PasswordDialog.this.passwordInput.setValue("");
                    PasswordDialog.this.passwordInput.focus();
                    if (PasswordDialog.this.retries >= 3) {
                        throw new OperationCanceledException(PasswordDialog.this.i18n.tr("{0} falsche Passwort-Eingaben", Integer.toString(3)));
                    }
                    return;
                }
                PasswordDialog.this.enteredPassword = p;
                PasswordDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("Dialog abgebrochen");
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
        this.addShellListener(new ShellListener(){

            public void shellClosed(ShellEvent e) {
                throw new OperationCanceledException("dialog cancelled via close button");
            }

            public void shellActivated(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
        this.getShell().setMinimumSize(this.getShell().computeSize(420, -1));
    }

    protected boolean checkUsername(String username) {
        boolean set;
        boolean bl = set = username != null && username.length() > 0;
        if (!set) {
            this.setErrorText(this.i18n.tr("Bitte geben Sie einen Namen ein."));
            return false;
        }
        return true;
    }

    protected boolean checkPassword(String password) {
        return true;
    }

    protected void extend(Container container) throws Exception {
    }

    protected void passwordModified(String password) {
    }

    protected int getRemainingRetries() {
        return 3 - this.retries;
    }

    protected Object getData() throws Exception {
        return this.enteredPassword;
    }

    public String getUsername() {
        return this.userInput != null ? (String)this.userInput.getValue() : this.enteredUsername;
    }

    public void setUsername(String username) {
        this.enteredUsername = username;
        if (this.userInput != null) {
            this.userInput.setValue(this.enteredUsername);
        }
    }

    public void setPassword(String password) {
        this.enteredPassword = password;
        if (this.passwordInput != null) {
            this.passwordInput.setValue(this.enteredPassword);
        }
    }
}

